using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using IndianHealthService.BMXNet;
using System.Diagnostics;
using IndianHealthService.BMXNet.WinForm;
using IndianHealthService.BMXNet.Services;
using IndianHealthService.BMXNet.WinForm.Configuration;

namespace IndianHealthService.BMXNet.Tools.SchemaBuilder
{
	public class MainWindow : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MainMenu mnuMain;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem changeServer;
		private System.Windows.Forms.MenuItem changeRpmsLogion;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem mnuHelpAbout;
		private System.Windows.Forms.Panel pnlStatusBar;
		private System.Windows.Forms.Panel pnlMain;
		private System.Windows.Forms.Splitter spltHorizontal;
		private System.Windows.Forms.Panel pnlFileField;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Panel pnlFile;
		private System.Windows.Forms.Splitter spltFileField;
		private System.Windows.Forms.Panel pnlField;
		private System.Windows.Forms.TreeView tvFile;
		private System.Windows.Forms.Label lblTreeView;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem mnuViewFiles;
		private System.Windows.Forms.MenuItem mnuViewStatusBar;
		private System.Windows.Forms.Panel pnlFieldGrid;
		private System.Windows.Forms.DataGrid grdFieldList;
		private System.Windows.Forms.MenuItem mnuFileNewSchema;
		private System.Windows.Forms.MenuItem mnuFileOpenSchema;
		private System.Windows.Forms.MenuItem mnuFileSave;
		private System.Windows.Forms.MenuItem mnuFileSaveAs;
		private System.Windows.Forms.MenuItem mnuFileExit;
		private System.Windows.Forms.ContextMenu mnuTreeNode;
		private System.Windows.Forms.MenuItem mnuSetSchemaFile;
        private Infragistics.Win.UltraWinGrid.UltraGrid ugrdSchemaFields;
        private IContainer components;

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MainWindow));
            this.mnuMain = new System.Windows.Forms.MainMenu(this.components);
            this.menuItem1 = new System.Windows.Forms.MenuItem();
            this.changeServer = new System.Windows.Forms.MenuItem();
            this.changeRpmsLogion = new System.Windows.Forms.MenuItem();
            this.menuItem4 = new System.Windows.Forms.MenuItem();
            this.mnuFileOpenSchema = new System.Windows.Forms.MenuItem();
            this.mnuFileNewSchema = new System.Windows.Forms.MenuItem();
            this.mnuFileSave = new System.Windows.Forms.MenuItem();
            this.mnuFileSaveAs = new System.Windows.Forms.MenuItem();
            this.menuItem9 = new System.Windows.Forms.MenuItem();
            this.mnuFileExit = new System.Windows.Forms.MenuItem();
            this.menuItem12 = new System.Windows.Forms.MenuItem();
            this.mnuViewFiles = new System.Windows.Forms.MenuItem();
            this.mnuViewStatusBar = new System.Windows.Forms.MenuItem();
            this.menuItem11 = new System.Windows.Forms.MenuItem();
            this.mnuHelpAbout = new System.Windows.Forms.MenuItem();
            this.pnlFileField = new System.Windows.Forms.Panel();
            this.pnlField = new System.Windows.Forms.Panel();
            this.grdFieldList = new System.Windows.Forms.DataGrid();
            this.spltFileField = new System.Windows.Forms.Splitter();
            this.pnlFile = new System.Windows.Forms.Panel();
            this.tvFile = new System.Windows.Forms.TreeView();
            this.mnuTreeNode = new System.Windows.Forms.ContextMenu();
            this.mnuSetSchemaFile = new System.Windows.Forms.MenuItem();
            this.lblTreeView = new System.Windows.Forms.Label();
            this.spltHorizontal = new System.Windows.Forms.Splitter();
            this.pnlStatusBar = new System.Windows.Forms.Panel();
            this.statusBar1 = new System.Windows.Forms.StatusBar();
            this.pnlMain = new System.Windows.Forms.Panel();
            this.pnlFieldGrid = new System.Windows.Forms.Panel();
            this.ugrdSchemaFields = new Infragistics.Win.UltraWinGrid.UltraGrid();
            this.pnlFileField.SuspendLayout();
            this.pnlField.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.grdFieldList)).BeginInit();
            this.pnlFile.SuspendLayout();
            this.pnlStatusBar.SuspendLayout();
            this.pnlMain.SuspendLayout();
            this.pnlFieldGrid.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.ugrdSchemaFields)).BeginInit();
            this.SuspendLayout();
            // 
            // mnuMain
            // 
            this.mnuMain.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItem1,
            this.menuItem12,
            this.menuItem11});
            // 
            // menuItem1
            // 
            this.menuItem1.Index = 0;
            this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.changeServer,
            this.changeRpmsLogion,
            this.menuItem4,
            this.mnuFileOpenSchema,
            this.mnuFileNewSchema,
            this.mnuFileSave,
            this.mnuFileSaveAs,
            this.menuItem9,
            this.mnuFileExit});
            this.menuItem1.Text = "&File";
            // 
            // changeServer
            // 
            this.changeServer.Index = 0;
            this.changeServer.Text = "Change RPMS Ser&ver";
            // 
            // changeRpmsLogion
            // 
            this.changeRpmsLogion.Index = 1;
            this.changeRpmsLogion.Text = "Change RPMS &Login";
            this.changeRpmsLogion.Click += new System.EventHandler(this.changeRpmsLogion_Click);
            // 
            // menuItem4
            // 
            this.menuItem4.Index = 2;
            this.menuItem4.Text = "-";
            // 
            // mnuFileOpenSchema
            // 
            this.mnuFileOpenSchema.Index = 3;
            this.mnuFileOpenSchema.Text = "&Open Schema...";
            this.mnuFileOpenSchema.Click += new System.EventHandler(this.mnuFileOpenSchema_Click);
            // 
            // mnuFileNewSchema
            // 
            this.mnuFileNewSchema.Index = 4;
            this.mnuFileNewSchema.Text = "&New Schema...";
            this.mnuFileNewSchema.Click += new System.EventHandler(this.mnuFileNewSchema_Click);
            // 
            // mnuFileSave
            // 
            this.mnuFileSave.Index = 5;
            this.mnuFileSave.Text = "&Save";
            this.mnuFileSave.Click += new System.EventHandler(this.mnuFileSave_Click);
            // 
            // mnuFileSaveAs
            // 
            this.mnuFileSaveAs.Index = 6;
            this.mnuFileSaveAs.Text = "Save &As";
            // 
            // menuItem9
            // 
            this.menuItem9.Index = 7;
            this.menuItem9.Text = "-";
            // 
            // mnuFileExit
            // 
            this.mnuFileExit.Index = 8;
            this.mnuFileExit.Text = "E&xit";
            // 
            // menuItem12
            // 
            this.menuItem12.Index = 1;
            this.menuItem12.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuViewFiles,
            this.mnuViewStatusBar});
            this.menuItem12.Text = "&View";
            // 
            // mnuViewFiles
            // 
            this.mnuViewFiles.Checked = true;
            this.mnuViewFiles.Index = 0;
            this.mnuViewFiles.Text = "&File and Fields";
            this.mnuViewFiles.Click += new System.EventHandler(this.mnuViewFiles_Click);
            // 
            // mnuViewStatusBar
            // 
            this.mnuViewStatusBar.Checked = true;
            this.mnuViewStatusBar.Index = 1;
            this.mnuViewStatusBar.Text = "&Status bar";
            this.mnuViewStatusBar.Click += new System.EventHandler(this.mnuViewStatusBar_Click);
            // 
            // menuItem11
            // 
            this.menuItem11.Index = 2;
            this.menuItem11.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuHelpAbout});
            this.menuItem11.Text = "&Help";
            // 
            // mnuHelpAbout
            // 
            this.mnuHelpAbout.Index = 0;
            this.mnuHelpAbout.Text = "&About";
            this.mnuHelpAbout.Click += new System.EventHandler(this.mnuHelpAbout_Click);
            // 
            // pnlFileField
            // 
            this.pnlFileField.Controls.Add(this.pnlField);
            this.pnlFileField.Controls.Add(this.spltFileField);
            this.pnlFileField.Controls.Add(this.pnlFile);
            this.pnlFileField.Dock = System.Windows.Forms.DockStyle.Top;
            this.pnlFileField.Location = new System.Drawing.Point(0, 0);
            this.pnlFileField.Name = "pnlFileField";
            this.pnlFileField.Size = new System.Drawing.Size(656, 300);
            this.pnlFileField.TabIndex = 0;
            // 
            // pnlField
            // 
            this.pnlField.Controls.Add(this.grdFieldList);
            this.pnlField.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlField.Location = new System.Drawing.Point(255, 0);
            this.pnlField.Name = "pnlField";
            this.pnlField.Size = new System.Drawing.Size(401, 300);
            this.pnlField.TabIndex = 3;
            // 
            // grdFieldList
            // 
            this.grdFieldList.AccessibleName = "DataGrid";
            this.grdFieldList.AccessibleRole = System.Windows.Forms.AccessibleRole.Table;
            this.grdFieldList.CaptionBackColor = System.Drawing.SystemColors.Control;
            this.grdFieldList.CaptionForeColor = System.Drawing.SystemColors.ControlText;
            this.grdFieldList.CaptionText = "Fields:";
            this.grdFieldList.DataMember = "";
            this.grdFieldList.Dock = System.Windows.Forms.DockStyle.Fill;
            this.grdFieldList.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.grdFieldList.ImeMode = System.Windows.Forms.ImeMode.NoControl;
            this.grdFieldList.Location = new System.Drawing.Point(0, 0);
            this.grdFieldList.Name = "grdFieldList";
            this.grdFieldList.ReadOnly = true;
            this.grdFieldList.Size = new System.Drawing.Size(401, 300);
            this.grdFieldList.TabIndex = 0;
            this.grdFieldList.MouseUp += new System.Windows.Forms.MouseEventHandler(this.grdFieldList_MouseUp);
            this.grdFieldList.MouseMove += new System.Windows.Forms.MouseEventHandler(this.grdFieldList_MouseMove);
            this.grdFieldList.MouseDown += new System.Windows.Forms.MouseEventHandler(this.grdFieldList_MouseDown);
            // 
            // spltFileField
            // 
            this.spltFileField.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.spltFileField.Location = new System.Drawing.Point(250, 0);
            this.spltFileField.Name = "spltFileField";
            this.spltFileField.Size = new System.Drawing.Size(5, 300);
            this.spltFileField.TabIndex = 2;
            this.spltFileField.TabStop = false;
            // 
            // pnlFile
            // 
            this.pnlFile.Controls.Add(this.tvFile);
            this.pnlFile.Controls.Add(this.lblTreeView);
            this.pnlFile.Dock = System.Windows.Forms.DockStyle.Left;
            this.pnlFile.Location = new System.Drawing.Point(0, 0);
            this.pnlFile.Name = "pnlFile";
            this.pnlFile.Size = new System.Drawing.Size(250, 300);
            this.pnlFile.TabIndex = 1;
            // 
            // tvFile
            // 
            this.tvFile.ContextMenu = this.mnuTreeNode;
            this.tvFile.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tvFile.Location = new System.Drawing.Point(0, 16);
            this.tvFile.Name = "tvFile";
            this.tvFile.Size = new System.Drawing.Size(250, 284);
            this.tvFile.TabIndex = 0;
            this.tvFile.BeforeExpand += new System.Windows.Forms.TreeViewCancelEventHandler(this.tvFile_BeforeExpand);
            this.tvFile.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.tvFile_AfterSelect);
            // 
            // mnuTreeNode
            // 
            this.mnuTreeNode.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.mnuSetSchemaFile});
            // 
            // mnuSetSchemaFile
            // 
            this.mnuSetSchemaFile.Index = 0;
            this.mnuSetSchemaFile.Text = "Set Schema File";
            this.mnuSetSchemaFile.Click += new System.EventHandler(this.mnuSetSchemaFile_Click);
            // 
            // lblTreeView
            // 
            this.lblTreeView.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.lblTreeView.Dock = System.Windows.Forms.DockStyle.Top;
            this.lblTreeView.Location = new System.Drawing.Point(0, 0);
            this.lblTreeView.Name = "lblTreeView";
            this.lblTreeView.Size = new System.Drawing.Size(250, 16);
            this.lblTreeView.TabIndex = 1;
            this.lblTreeView.Text = "FileMan File:";
            // 
            // spltHorizontal
            // 
            this.spltHorizontal.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.spltHorizontal.Dock = System.Windows.Forms.DockStyle.Top;
            this.spltHorizontal.Location = new System.Drawing.Point(0, 300);
            this.spltHorizontal.Name = "spltHorizontal";
            this.spltHorizontal.Size = new System.Drawing.Size(656, 5);
            this.spltHorizontal.TabIndex = 1;
            this.spltHorizontal.TabStop = false;
            // 
            // pnlStatusBar
            // 
            this.pnlStatusBar.Controls.Add(this.statusBar1);
            this.pnlStatusBar.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.pnlStatusBar.Location = new System.Drawing.Point(0, 521);
            this.pnlStatusBar.Name = "pnlStatusBar";
            this.pnlStatusBar.Size = new System.Drawing.Size(656, 24);
            this.pnlStatusBar.TabIndex = 2;
            // 
            // statusBar1
            // 
            this.statusBar1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.statusBar1.Location = new System.Drawing.Point(0, 0);
            this.statusBar1.Name = "statusBar1";
            this.statusBar1.Size = new System.Drawing.Size(656, 24);
            this.statusBar1.TabIndex = 0;
            this.statusBar1.Text = "statusBar1";
            // 
            // pnlMain
            // 
            this.pnlMain.AutoScroll = true;
            this.pnlMain.Controls.Add(this.pnlFieldGrid);
            this.pnlMain.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlMain.Location = new System.Drawing.Point(0, 305);
            this.pnlMain.Name = "pnlMain";
            this.pnlMain.Size = new System.Drawing.Size(656, 216);
            this.pnlMain.TabIndex = 3;
            // 
            // pnlFieldGrid
            // 
            this.pnlFieldGrid.Controls.Add(this.ugrdSchemaFields);
            this.pnlFieldGrid.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlFieldGrid.Location = new System.Drawing.Point(0, 0);
            this.pnlFieldGrid.Name = "pnlFieldGrid";
            this.pnlFieldGrid.Size = new System.Drawing.Size(656, 216);
            this.pnlFieldGrid.TabIndex = 2;
            // 
            // ugrdSchemaFields
            // 
            this.ugrdSchemaFields.AllowDrop = true;
            this.ugrdSchemaFields.Cursor = System.Windows.Forms.Cursors.Default;
            this.ugrdSchemaFields.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ugrdSchemaFields.Location = new System.Drawing.Point(0, 0);
            this.ugrdSchemaFields.Name = "ugrdSchemaFields";
            this.ugrdSchemaFields.Size = new System.Drawing.Size(656, 216);
            this.ugrdSchemaFields.TabIndex = 1;
            this.ugrdSchemaFields.Text = "Schema File:";
            this.ugrdSchemaFields.InitializeLayout += new Infragistics.Win.UltraWinGrid.InitializeLayoutEventHandler(this.ugrdSchemaFields_InitializeLayout);
            this.ugrdSchemaFields.DragDrop += new System.Windows.Forms.DragEventHandler(this.ugrdSchemaFields_DragDrop);
            this.ugrdSchemaFields.DragEnter += new System.Windows.Forms.DragEventHandler(this.ugrdSchemaFields_DragEnter);
            // 
            // MainWindow
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(656, 545);
            this.Controls.Add(this.pnlMain);
            this.Controls.Add(this.pnlStatusBar);
            this.Controls.Add(this.spltHorizontal);
            this.Controls.Add(this.pnlFileField);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Menu = this.mnuMain;
            this.Name = "MainWindow";
            this.Text = "BMX Schema Builder";
            this.Load += new System.EventHandler(this.frmMain_Load);
            this.pnlFileField.ResumeLayout(false);
            this.pnlField.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.grdFieldList)).EndInit();
            this.pnlFile.ResumeLayout(false);
            this.pnlStatusBar.ResumeLayout(false);
            this.pnlMain.ResumeLayout(false);
            this.pnlFieldGrid.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.ugrdSchemaFields)).EndInit();
            this.ResumeLayout(false);

		}
		#endregion

		#region Fields

        private BMXSchemaDoc _document;

        public BMXSchemaDoc Document
        {
            get { return _document; }
            set { _document = value; }
        }

        private string _appName = "BMXSchemaBuilder";

        public string AppName
        {
            get { return _appName; }
            set { _appName = value; }
        }
		private bool				m_bMouseDown;
		private bool				m_bDragDropStart;

		#endregion Fields

		#region Methods	


		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}



        private WinFramework _framework = null;

        public WinFramework Framework
        {
            get { return _framework; }
            set { _framework = value; }
        }

        private RemoteSession _remoteSession = null;

        public RemoteSession RemoteSession
        {
            get { return _remoteSession; }
            set { _remoteSession = value; }
        }


        private void frmMain_Load(object sender, System.EventArgs e)
        {
            this.Login(false);
        
        }

        public void Login(bool isSwitchServer)
        {
            if (this.Framework == null)
            {
                this.Framework = WinFramework.CreateWithNetworkBroker(true);
                this.Framework.LoadConnectionSpecs(LocalPersistentStore.CreateDefaultStorage(true), "SchemaBuilder");

                LoginProcess login = this.Framework.CreateLoginProcess();
                login.IsSwitchServerModeEnabled = isSwitchServer;
       
                if (login.HasDefaultConnectionWithUseWindowsAuth && login.AttemptWindowsAuthLogin())
                {
                    login.AttemptWindowsAuthLogin();
                }

                if (!login.WasLoginAttempted || !login.WasSuccessful)
                {
                    login.AttemptUserInputLogin("Schema Builder Login", 3, true, this);
                }

                if (!login.WasSuccessful)
                {
                    this.Close();
                    return;
                }
                LocalSession local = this.Framework.LocalSession;

                if (!this.Framework.AttemptUserInputSetDivision("Set Initial Division", this))
                {
                    this.Close();
                    return;
                }

                this.RemoteSession = this.Framework.PrimaryRemoteSession;

                this.UpdateTitle();
                this.SetGridStyle();
                this.LoadFileTree();
                this.LoadNewSchema();
                this.FormatSchemaFieldsGrid();
            }
        }

        private void UpdateTitle()
        {
           
        }
    
		private void LoadFileTree()
		{
            try
            {
                tvFile.BeginUpdate();
                tvFile.Nodes.Clear();

                DataTable dtFile = this.RemoteSession.TableFromCommand("BMX ADO SS^FILEMAN FILES^^B~A~ZZZ~5000");
           
                //DataView dvFile = new DataView(dtFile);
             
                this.AddSubFileNodes(tvFile.Nodes, dtFile);
            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                tvFile.EndUpdate();
            }
		}

        private DataTable GetSubfiles(string sFileNum)
        {
            return this.RemoteSession.TableFromCommand("BMX ADO SS^SUBFILES^^~~~~~SFIT~BMXADOS1~" + sFileNum + "~");
        }

		public void LoadNewSchema()
		{
			this.Document.NewSchema();
			this.ugrdSchemaFields.DataSource = this.Document.SchemaFields;
            this.Text = this.AppName + " - " + this.Document.SchemaName;
			string sGridText = "Schema File: ";
			this.ugrdSchemaFields.Text = sGridText;
		}

	
		#endregion Methods		

		#region TreeNode

		private void AddSubFileNodes(TreeNodeCollection nodParentColl, DataTable dt)
		{
			string sFileName;
			string sExpand;
			string sFileNumber;
			DataView dvFile = new DataView(dt);
			DataRowView drv;
			TreeNode tn;
			for (int j=0; j < dvFile.Count; j++)
			{
				drv = dvFile[j];
				sFileName = drv["NAME"].ToString();
				sFileNumber = drv["BMXIEN"].ToString();
				sExpand = drv["SUBFILES PRESENT?"].ToString();
				tn = new TreeNode(sFileName);
				tn.Text = sFileName;
				tn.Tag = sFileNumber;
				if (sExpand == "+")
				{
					tn.Nodes.Add(".");
				}
				nodParentColl.Add(tn);
			}		
		}

		private void tvFile_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			try
			{
				string sNode = e.Node.Text;
				string sFileNumber =  e.Node.Tag.ToString();
				string sCmd = "BMX ADO SS^FIELDS^^~~~~~FLDIT~BMXADOS1~" + sFileNumber + "~";
                //DataTable dtFields = this.Bmx.TableFromAdoRPC(sCmd, "FIELDS", new DataSet(), "BMXRPC");
			
				//this.grdFieldList.DataSource = dtFields;
			}
			catch (Exception ex)
			{
                this.Framework.LocalSession.Notify("Error in " + this.AppName, ex);
            }		

		}

		private void tvFile_BeforeExpand(object sender, System.Windows.Forms.TreeViewCancelEventArgs e)
		{
			try
			{
				string sNode = e.Node.Text;
				string sFileNumber =  e.Node.Tag.ToString();
				e.Node.Nodes.Clear();
				DataTable dtSubFiles = this.GetSubfiles(sFileNumber);
				AddSubFileNodes(e.Node.Nodes, dtSubFiles);
			}
			catch (Exception ex)
			{
                this.Framework.LocalSession.Notify("Error in " + this.AppName, ex);
			}
		}


		#endregion TreeNode

		#region MouseHandlers

		private void grdFieldList_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			m_bMouseDown = true;
			m_bDragDropStart = false;
			Debug.WriteLine("MouseDown" + e.Button.ToString());
		}

		private void grdFieldList_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (m_bMouseDown == true)
			{
				if (m_bDragDropStart == false)
				{
					string[] sData = new string[2];
					DataGridCell dCell = grdFieldList.CurrentCell;
					dCell.ColumnNumber = 0;
					sData[0] = grdFieldList[dCell].ToString();
					dCell.ColumnNumber = 1;
					sData[1] = grdFieldList[dCell].ToString();
					DragDropEffects effect = DoDragDrop(sData, DragDropEffects.Move);
					m_bDragDropStart = true;
				}
			}
		}

		private void grdFieldList_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			Debug.WriteLine("MouseUp" + e.Button.ToString());
			m_bMouseDown = false;
		}

		#endregion MouseHandlers



		#region UltraGrid

		private void SetGridStyle()
		{
			//Fileman Fields Grid
			DataGridTableStyle tsFields = new DataGridTableStyle();
			tsFields.MappingName = "FIELDS";
			tsFields.ReadOnly = true;
			tsFields.RowHeadersVisible = false;

			// Add FIELD NUMBER column style.
			DataGridColumnStyle colFieldNumber = new DataGridTextBoxColumn();
			colFieldNumber.MappingName = "BMXIEN";
			colFieldNumber.HeaderText = "Field Number";
			colFieldNumber.Width = 100;
			tsFields.GridColumnStyles.Add(colFieldNumber);
			// Add FIELD NAME column style.
			DataGridColumnStyle colFieldName = new DataGridTextBoxColumn();
			colFieldName.MappingName = "NAME";
			colFieldName.HeaderText = "Field Name";
			colFieldName.Width = 290;
			tsFields.GridColumnStyles.Add(colFieldName);

			this.grdFieldList.TableStyles.Add(tsFields);
		}

		private void FormatSchemaFieldsGrid()
		{
			Infragistics.Win.ValueListsCollection vlSchemaFields;
			Infragistics.Win.UltraWinGrid.UltraGridBand bndSchemaFields;

			vlSchemaFields = ugrdSchemaFields.DisplayLayout.ValueLists;
			vlSchemaFields.Add("YesNo");
			vlSchemaFields["YesNo"].ValueListItems.Add("YES");
			vlSchemaFields["YesNo"].ValueListItems.Add("NO");
			vlSchemaFields.Add("DataType");
			vlSchemaFields["DataType"].ValueListItems.Add("TEXT");
			vlSchemaFields["DataType"].ValueListItems.Add("DATE");
			vlSchemaFields["DataType"].ValueListItems.Add("INTEGER");
			vlSchemaFields["DataType"].ValueListItems.Add("NUMBER");

			bndSchemaFields = ugrdSchemaFields.DisplayLayout.Bands[0];
			bndSchemaFields.Columns["READ ONLY"].ValueList = vlSchemaFields["YesNo"];
			bndSchemaFields.Columns["KEY FIELD"].ValueList = vlSchemaFields["YesNo"];
			bndSchemaFields.Columns["NULL ALLOWED"].ValueList = vlSchemaFields["YesNo"];
			bndSchemaFields.Columns["IEN AUTOMATICALLY INCLUDED"].ValueList = vlSchemaFields["YesNo"];
			bndSchemaFields.Columns["DATA TYPE"].ValueList = vlSchemaFields["DataType"];

			bndSchemaFields.Columns["BMXIEN"].Hidden = true;
			bndSchemaFields.Columns["BMXIEN1"].Hidden = true;

		}

		private void ugrdSchemaFields_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
		{
			try
			{
				string[] sData = (string[]) e.Data.GetData(typeof(string[]));
				m_bDragDropStart = false;
				DataTable dt = (DataTable) ugrdSchemaFields.DataSource;
				DataRow dr = dt.NewRow();
				double nField = Convert.ToDouble(sData[0]);
				string sField = nField.ToString(".#####");
				dr["FIELD NUMBER"] =sField ;
				dr["COLUMN HEADER"] = sData[1];
				dt.Rows.Add(dr);
				Document.SchemaFields = dt;
				ugrdSchemaFields.DataSource = Document.SchemaFields;
				ugrdSchemaFields.Refresh();
			}
			catch (Exception ex)
			{
                this.Framework.LocalSession.Notify("Error in " + this.AppName, ex);
            }		
		}

		private void ugrdSchemaFields_DragEnter(object sender, System.Windows.Forms.DragEventArgs e)
		{
			bool b = e.Data.GetDataPresent(typeof(string[]));
			if (b == true)
			{
				if ((e.KeyState & 8) == 8) //CTRL key
				{
					e.Effect = DragDropEffects.Copy;
				}
				else
				{
					e.Effect = DragDropEffects.Move;
				}
			}
			else
			{
				e.Effect = DragDropEffects.None;
			}		
		}

		private void ugrdSchemaFields_InitializeLayout(object sender, Infragistics.Win.UltraWinGrid.InitializeLayoutEventArgs e)
		{
			e.Layout.Override.HeaderClickAction =  Infragistics.Win.UltraWinGrid.HeaderClickAction.SortMulti;
		}
		#endregion UltraGrid

		#region MenuHandlers

		private void mnuHelpAbout_Click(object sender, System.EventArgs e)
		{
            new AboutDialog().ShowDialog();
		}

		private void mnuViewFiles_Click(object sender, System.EventArgs e)
		{
			mnuViewFiles.Checked = !(mnuViewFiles.Checked);
			pnlFileField.Visible = mnuViewFiles.Checked;
		}

		private void mnuViewStatusBar_Click(object sender, System.EventArgs e)
		{
			mnuViewStatusBar.Checked = !(mnuViewStatusBar.Checked);
			this.statusBar1.Visible = mnuViewStatusBar.Checked;
		}

		private void mnuFileNewSchema_Click(object sender, System.EventArgs e)
		{
			LoadNewSchema();
		}

		private void mnuFileSave_Click(object sender, System.EventArgs e)
		{
			try
			{
				if (Document.SchemaIEN == 0)
				{
					//prompt for a name
					DSaveSchema dSave = new DSaveSchema();
					if (dSave.ShowDialog() == DialogResult.Cancel)
						return;
					this.Document.SaveSchema(dSave.SchemaName);
					this.Text = this.AppName + " - " + Document.SchemaName;
				
				}
				else
				{
					this.Document.SaveSchema();
				}
			}
			catch (Exception ex)
			{
                this.Framework.LocalSession.Notify("Error in " + this.AppName, ex);
            }
		}

		private void mnuFileOpenSchema_Click(object sender, System.EventArgs e)
		{
			//Display a dialog to select from existing schemas
			DSelectSchema dss = new DSelectSchema();
		//	dss.InitializePage(this);
			if (dss.ShowDialog() == DialogResult.Cancel)
				return;

			Document.OpenSchema(dss.SchemaIEN, dss.SchemaName, dss.FileNumber);
			ugrdSchemaFields.DataSource = Document.SchemaFields;
			ugrdSchemaFields.Refresh();

			string sGridText = "Schema File: " + Document.SchemaFileName + " (Number "+ Document.SchemaFileNumber.ToString() + ")";
			if (Document.SchemaReadOnlyDataset == true)
				sGridText += " [Dataset is ReadOnly]";
			this.ugrdSchemaFields.Text = sGridText;
			this.Text = this.AppName + " - " + Document.SchemaName;
		}

		private void mnuSetSchemaFile_Click(object sender, System.EventArgs e)
		{
			Document.SchemaFileName = this.tvFile.SelectedNode.Text;
			Document.SchemaFileNumber = Convert.ToDouble(this.tvFile.SelectedNode.Tag);
			ugrdSchemaFields.Text = "Schema File:  " + Document.SchemaFileName;
			ugrdSchemaFields.Text += " (Number " + Document.SchemaFileNumber.ToString() + ")";
		}


		#endregion MenuHandlers

        private void changeRpmsLogion_Click(object sender, EventArgs e)
        {
            this.Framework.Close();
            this.Framework = null;
            this.Login(true);
        
        }

	

	}
}
